import os
import shutil
import os.path as osp

def rename_files_in_directory(directory, subfolders):
    for subfolder,sub1 in subfolders:
        folder_path = os.path.join(directory, subfolder)
        folder2_path = os.path.join(directory, sub1)
        if os.path.isdir(folder_path):
            for filename in os.listdir(folder_path):
                file_path = os.path.join(folder_path, filename)
                name, ext = os.path.splitext(filename)
                if ext in ['.truth', '.html']:
                    try:
                        prefix_num = int(name)+1
                        new_name = f"{prefix_num}{ext}"
                        os.rename(file_path, os.path.join(folder2_path, new_name))
                    except ValueError:
                        continue

def rename(dir):
    source_dir = osp.join(dir,'and1280')
    target_dir = osp.join(dir,'and1280+')
    for subdir in ['aag', 'bnet', 'pic', 'tt']:
        source_subdir = os.path.join(source_dir, subdir)
        target_subdir = os.path.join(target_dir, subdir)
        if not os.path.exists(target_subdir):
            os.makedirs(target_subdir)

        for filename in os.listdir(source_subdir):
            if filename[0].isdigit():
                fn = filename.split('.')
                new_filename = str(int(fn[0])+87)+'.'+fn[1]
                shutil.move(os.path.join(source_subdir, filename),
                            os.path.join(target_subdir, new_filename))  # move and rename


# rename_files_in_directory('generated_aigs/in40_out40_tt15/and1280', [('tt','tt1'), ('pic','pic1')])
rename('generated_aigs/in40_out40_tt15_0')


